/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.users.controller;

import com.example.soso.security.domain.CustomUserDetails;
import com.example.soso.users.domain.dto.UserResponse;
import com.example.soso.users.service.UsersService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Users", description="\uc0ac\uc6a9\uc790 \uc815\ubcf4 \uad00\ub828 API")
@RestController
@RequestMapping(value={"/users"})
public class UsersController {
    private final UsersService usersService;

    @Operation(summary="\ubcf8\uc778 \uc815\ubcf4 \uc870\ud68c", description="\ud604\uc7ac \ub85c\uadf8\uc778\ud55c \uc0ac\uc6a9\uc790\uc758 \uc804\uccb4 \uc815\ubcf4\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4.\n\n**\uc778\uc99d \ud544\uc694:** JWT Access Token\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\n\n**\uc751\ub2f5 \uc815\ubcf4:**\n- \uae30\ubcf8 \uc815\ubcf4: ID, \uc0ac\uc6a9\uc790\uba85, \ub2c9\ub124\uc784, \uc774\uba54\uc77c\n- \ud504\ub85c\ud544: \ud504\ub85c\ud544 \uc774\ubbf8\uc9c0 URL\n- \uac1c\uc778 \uc815\ubcf4: \uc131\ubcc4, \uc5f0\ub839\ub300\n- \ucc3d\uc5c5 \uc815\ubcf4: \uc0ac\uc6a9\uc790 \uc720\ud615, \uc608\uc0b0, \ucc3d\uc5c5 \uacbd\ud5d8, \uad00\uc2ec \uc5c5\uc885\n- \uc704\uce58 \uc815\ubcf4: \uc9c0\uc5ed\uba85, \uc704\ub3c4, \uacbd\ub3c4\n- \uc2dc\uc2a4\ud15c \uc815\ubcf4: \uc0dd\uc131\uc77c\uc2dc, \uc218\uc815\uc77c\uc2dc\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc0ac\uc6a9\uc790 \uc815\ubcf4 \uc870\ud68c \uc131\uacf5", content={@Content(schema=@Schema(implementation=UserResponse.class))}), @ApiResponse(responseCode="401", description="\uc778\uc99d\ub418\uc9c0 \uc54a\uc740 \uc0ac\uc6a9\uc790", content={@Content(schema=@Schema(ref="#/components/schemas/ErrorResponse"))}), @ApiResponse(responseCode="404", description="\uc0ac\uc6a9\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(ref="#/components/schemas/ErrorResponse"))})})
    @GetMapping(value={"/me"})
    public ResponseEntity<UserResponse> getCurrentUser(@AuthenticationPrincipal CustomUserDetails userDetails) {
        UserResponse userResponse = this.usersService.getCurrentUserInfo(userDetails.getUsername());
        return ResponseEntity.ok((Object)userResponse);
    }

    @Generated
    public UsersController(UsersService usersService) {
        this.usersService = usersService;
    }
}

