/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.comment.domain.repository;

import com.example.soso.community.common.comment.domain.entity.Comment;
import com.example.soso.community.common.post.domain.entity.Post;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CommentRepository
extends JpaRepository<Comment, Long> {
    @Modifying
    @Query(value="UPDATE Comment c SET c.likeCount = :count WHERE c.id = :commentId")
    public void updateLikeCount(@Param(value="commentId") Long var1, @Param(value="count") long var2);

    public List<Comment> findAllByPost(Post var1);

    public Optional<Comment> findByIdAndUserId(Long var1, String var2);

    public Optional<Comment> findByIdAndPostId(Long var1, Long var2);

    @Query(value="select c.id from Comment c where c.post.id = :postId")
    public List<Long> findIdsByPostId(@Param(value="postId") Long var1);

    public List<Comment> findByPostIdAndDeletedFalse(Long var1, Pageable var2);

    public List<Comment> findByParentId(Long var1);

    public int countByParentIdAndDeletedFalse(Long var1);

    public Optional<Comment> findByIdAndDeletedFalse(Long var1);

    public int countByPostIdAndDeletedFalse(Long var1);

    public long countByPostId(Long var1);

    public List<Comment> findByPostIdAndDeletedFalseAndCreatedDateBefore(Long var1, LocalDateTime var2, Pageable var3);

    public List<Comment> findByPostIdAndDeletedFalseAndCreatedDateAfter(Long var1, LocalDateTime var2, Pageable var3);

    public List<Comment> findByPostId(Long var1, Pageable var2);

    public List<Comment> findByPostIdAndCreatedDateBefore(Long var1, LocalDateTime var2, Pageable var3);

    public List<Comment> findByPostIdAndCreatedDateAfter(Long var1, LocalDateTime var2, Pageable var3);
}

