/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.freeboard.post.controller;

import com.example.soso.community.common.post.domain.entity.Category;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardCreateRequest;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardCreateResponse;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardCursorResponse;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardDetailResponse;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardSortType;
import com.example.soso.community.freeboard.post.domain.dto.FreeboardUpdateRequest;
import com.example.soso.community.freeboard.post.service.FreeboardService;
import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.global.exception.util.PostException;
import com.example.soso.security.domain.CustomUserDetails;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Freeboard", description="\uc790\uc720\uac8c\uc2dc\ud310 API")
@RestController
@RequestMapping(value={"/community/freeboard"})
public class FreeboardController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FreeboardController.class);
    private final FreeboardService freeboardService;

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc791\uc131", description="\uc790\uc720\uac8c\uc2dc\ud310\uc5d0 \uc0c8 \uae00\uc744 \uc791\uc131\ud569\ub2c8\ub2e4.\n\n**\ud2b9\uc9d5:**\n- \uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc9c0\uc6d0 (\ucd5c\ub300 4\uc7a5)\n- Multipart \ubc29\uc2dd\uc73c\ub85c \uc774\ubbf8\uc9c0\uc640 \ud14d\uc2a4\ud2b8 \ub370\uc774\ud130\ub97c \ud568\uaed8 \uc804\uc1a1\n- \uce74\ud14c\uace0\ub9ac \ud544\uc218 \uc120\ud0dd\n\n**\uc9c0\uc6d0 \ud30c\uc77c \ud615\uc2dd:** jpg, jpeg, png, gif\n**\ucd5c\ub300 \ud30c\uc77c \ud06c\uae30:** 5MB per image\n", requestBody=@RequestBody(content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=FreeboardCreateRequest.class))}))
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uac8c\uc2dc\uae00 \uc791\uc131 \uc131\uacf5", content={@Content(schema=@Schema(implementation=FreeboardCreateResponse.class), examples={@ExampleObject(value="{\"postId\": 123}")})}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad (\uac80\uc99d \uc2e4\ud328, \uc774\ubbf8\uc9c0 \uad00\ub828 \uc624\ub958)", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ube48 \uc81c\ubaa9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[title] \uc81c\ubaa9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\ube48 \ub0b4\uc6a9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[content] \ub0b4\uc6a9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \uce74\ud14c\uace0\ub9ac", value="{\"code\": \"INVALID_ENUM_VALUE\", \"message\": \"'invalid-category'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [daily-hobby, restaurant, living-convenience, neighborhood-news, startup, others]\"}"), @ExampleObject(name="\uc774\ubbf8\uc9c0 \uac1c\uc218 \ucd08\uacfc", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc774\ubbf8\uc9c0\ub294 \ucd5c\ub300 4\uc7a5\uae4c\uc9c0 \uc5c5\ub85c\ub4dc \uac00\ub2a5\ud569\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c \ud615\uc2dd", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c \ud615\uc2dd\uc785\ub2c8\ub2e4. \uc9c0\uc6d0 \ud615\uc2dd: image/jpeg, image/jpg, image/png, image/gif, image/webp\"}"), @ExampleObject(name="\ube48 \ud30c\uc77c", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc774\ubbf8\uc9c0 \ud30c\uc77c\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="413", description="\ud30c\uc77c \ud06c\uae30 \ucd08\uacfc (Spring multipart \uc81c\ud55c)", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"FILE_SIZE_EXCEEDED\", \"message\": \"\ud30c\uc77c \ud06c\uae30\uac00 \ub108\ubb34 \ud07d\ub2c8\ub2e4. \ucd5c\ub300 \uc5c5\ub85c\ub4dc \ud06c\uae30\ub294 5MB\uc785\ub2c8\ub2e4.\"}")})})})
    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<?> createPost(@ModelAttribute @Valid FreeboardCreateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc791\uc131 \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c");
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc791\uc131 \uc694\uccad: userId={}, category={}, title={}, imageCount={}", new Object[]{userDetails.getUser().getId(), request.getCategory(), request.getTitle(), request.getImages() != null ? request.getImages().size() : 0});
        String userId = userDetails.getUser().getId();
        FreeboardCreateResponse response = this.freeboardService.createPost(request, userId);
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc791\uc131 \uc644\ub8cc: postId={}", (Object)response.getPostId());
        return ResponseEntity.ok((Object)response);
    }

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc0c1\uc138 \uc870\ud68c", description="\uac8c\uc2dc\uae00 ID\ub97c \ud1b5\ud574 \ud2b9\uc815 \uac8c\uc2dc\uae00\uc758 \uc0c1\uc138 \uc815\ubcf4\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4.\n\n**\ud2b9\uc9d5:**\n- \uc870\ud68c \uc2dc \uc870\ud68c\uc218 \uc790\ub3d9 \uc99d\uac00\n- \uc778\uc99d/\ube44\uc778\uc99d \uc0ac\uc6a9\uc790 \ubaa8\ub450 \uc870\ud68c \uac00\ub2a5\n- \uc778\uc99d \uc5ec\ubd80\uc5d0 \ub530\ub77c isLiked, canEdit, canDelete \uac12 \ubcc0\uacbd\n\n**\uc778\uc99d \uc0ac\uc6a9\uc790:**\n- isAuthorized: true\n- isLiked: boolean (\uc88b\uc544\uc694 \uc0c1\ud0dc)\n- canEdit: boolean (\uc218\uc815 \uad8c\ud55c)\n- canDelete: boolean (\uc0ad\uc81c \uad8c\ud55c)\n\n**\ube44\uc778\uc99d \uc0ac\uc6a9\uc790:**\n- isAuthorized: false\n- isLiked: null\n- canEdit: null\n- canDelete: null\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc870\ud68c \uc131\uacf5", content={@Content(schema=@Schema(implementation=FreeboardDetailResponse.class), examples={@ExampleObject(name="\uc778\uc99d \uc0ac\uc6a9\uc790 (\ubcf8\uc778 \uc791\uc131)", value="{\"postId\":123,\"author\":{\"userId\":\"author123\",\"nickname\":\"\uc791\uc131\uc790\",\"profileImageUrl\":\"https://cdn.example.com/profile.jpg\",\"userType\":\"INHABITANT\",\"address\":\"\uc11c\uc6b8\uc2dc \uac15\ub0a8\uad6c\"},\"category\":\"restaurant\",\"title\":\"\ub9db\uc788\ub294 \ub77c\uba74\uc9d1 \ucd94\ucc9c\ud574\uc694!\",\"content\":\"\uc778\uc99d \uc0ac\uc6a9\uc790\uac00 \uc791\uc131\ud55c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.\",\"images\":[{\"imageId\":1,\"imageUrl\":\"https://cdn.example.com/image1.jpg\",\"sequence\":0}],\"likeCount\":10,\"commentCount\":3,\"viewCount\":120,\"createdAt\":\"2025-01-01T10:00:00\",\"updatedAt\":\"2025-01-02T09:30:00\",\"isAuthorized\":true,\"isAuthor\":true,\"isLiked\":false,\"canEdit\":true,\"canDelete\":true}"), @ExampleObject(name="\uc778\uc99d \uc0ac\uc6a9\uc790 (\ub2e4\ub978 \uc0ac\ub78c \uae00, \uc88b\uc544\uc694 \ub204\ub984)", value="{\"postId\":456,\"author\":{\"userId\":\"other-user\",\"nickname\":\"\ub2e4\ub978\uc0ac\uc6a9\uc790\",\"profileImageUrl\":\"https://cdn.example.com/profile2.jpg\",\"userType\":\"FOUNDER\",\"address\":\"\uc11c\uc6b8\uc2dc \uc11c\ucd08\uad6c\"},\"category\":\"startup\",\"title\":\"\ucc3d\uc5c5 \uc131\uacf5 \uc2a4\ud1a0\ub9ac\",\"content\":\"3\uac1c\uc6d4\ub9cc\uc5d0 \ub9e4\ucd9c 10\ubc30 \uc99d\uac00!\",\"images\":[],\"likeCount\":50,\"commentCount\":15,\"viewCount\":500,\"createdAt\":\"2025-01-05T14:20:00\",\"updatedAt\":\"2025-01-06T10:15:00\",\"isAuthorized\":true,\"isAuthor\":false,\"isLiked\":true,\"canEdit\":false,\"canDelete\":false}"), @ExampleObject(name="\ube44\uc778\uc99d \uc0ac\uc6a9\uc790", value="{\"postId\":123,\"author\":{\"userId\":\"author123\",\"nickname\":\"\uc791\uc131\uc790\",\"profileImageUrl\":\"https://cdn.example.com/profile.jpg\",\"userType\":\"INHABITANT\",\"address\":\"\uc11c\uc6b8\uc2dc \uac15\ub0a8\uad6c\"},\"category\":\"restaurant\",\"title\":\"\ub9db\uc788\ub294 \ub77c\uba74\uc9d1 \ucd94\ucc9c\ud574\uc694!\",\"content\":\"\ube44\uc778\uc99d \uc0ac\uc6a9\uc790\uac00 \uc870\ud68c\ud55c \uac8c\uc2dc\uae00\uc785\ub2c8\ub2e4.\",\"images\":[],\"likeCount\":10,\"commentCount\":3,\"viewCount\":120,\"createdAt\":\"2025-01-01T10:00:00\",\"isAuthorized\":false,\"isAuthor\":false,\"isLiked\":null,\"canEdit\":null,\"canDelete\":null}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @GetMapping(value={"/{freeboardId}"})
    public ResponseEntity<FreeboardDetailResponse> getPost(@Parameter(description="\uc870\ud68c\ud560 \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long freeboardId) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userId = null;
        if (authentication != null && authentication.isAuthenticated() && !"anonymousUser".equals(authentication.getPrincipal()) && authentication.getPrincipal() instanceof CustomUserDetails) {
            CustomUserDetails userDetails = (CustomUserDetails)authentication.getPrincipal();
            userId = userDetails.getUser().getId();
        }
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc870\ud68c \uc694\uccad: freeboardId={}, userId={}", (Object)freeboardId, (Object)(userId != null ? userId : "anonymous"));
        FreeboardDetailResponse response = this.freeboardService.getPost(freeboardId, userId);
        log.debug("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc870\ud68c \uc644\ub8cc: freeboardId={}, viewCount={}", (Object)freeboardId, (Object)response.getViewCount());
        return ResponseEntity.ok((Object)response);
    }

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \ubaa9\ub85d \uc870\ud68c (\ucee4\uc11c \uae30\ubc18)", description="\ucee4\uc11c \uae30\ubc18 \ud398\uc774\uc9c0\ub124\uc774\uc158\uc744 \uc0ac\uc6a9\ud558\uc5ec \uac8c\uc2dc\uae00 \ubaa9\ub85d\uc744 \uc870\ud68c\ud569\ub2c8\ub2e4.\n\n**\uc815\ub82c \uc635\uc158:**\n- LATEST: \ucd5c\uc2e0\uc21c (\uae30\ubcf8\uac12)\n- LIKE: \uc88b\uc544\uc694\uc21c\n- COMMENT: \ub313\uae00\uc21c\n- VIEW: \uc870\ud68c\uc21c\n\n**\ucee4\uc11c \uc0ac\uc6a9\ubc95:**\n\uccab \uc694\uccad: cursor \uc5c6\uc774 \uc694\uccad\n\ub2e4\uc74c \ud398\uc774\uc9c0: \uc774\uc804 \uc751\ub2f5\uc758 nextCursor \uac12\uc744 \uc0ac\uc6a9\n", parameters={@Parameter(name="category", description="\ud544\ud130\ub9c1\ud560 \uce74\ud14c\uace0\ub9ac (\uc120\ud0dd\uc0ac\ud56d)\n\n**\uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12:**\n- daily-hobby: \uc77c\uc0c1/\ucde8\ubbf8\n- restaurant: \ub9db\uc9d1\n- living-convenience: \uc0dd\ud65c/\uafc0\ud301\n- neighborhood-news: \ub3d9\ub124\uc18c\uc2dd\n- startup: \ucc3d\uc5c5\n- others: \uae30\ud0c0\n\n**\ubbf8\uc785\ub825 \uc2dc:** \uc804\uccb4 \uac8c\uc2dc\uae00 \uc870\ud68c\n", example="restaurant", schema=@Schema(allowableValues={"daily-hobby", "restaurant", "living-convenience", "neighborhood-news", "startup", "others"})), @Parameter(name="sort", description="\uc815\ub82c \uae30\uc900\n\n- LATEST: \ucd5c\uc2e0\uc21c (\uae30\ubcf8\uac12)\n- LIKE: \uc88b\uc544\uc694\uc21c\n- COMMENT: \ub313\uae00\uc21c\n- VIEW: \uc870\ud68c\uc21c\n", example="LATEST"), @Parameter(name="cursor", description="\ucee4\uc11c \uae30\ubc18 \ud398\uc774\uc9d5\uc744 \uc704\ud55c \ucee4\uc11c \uac12\n\n**\uccab \uc694\uccad:** cursor \uc5c6\uc774 \uc694\uccad\n**\ub2e4\uc74c \ud398\uc774\uc9c0:** \uc774\uc804 \uc751\ub2f5\uc758 nextCursor \uac12 \uc0ac\uc6a9\n", example="eyJpZCI6MTIzLCJzb3J0VmFsdWUiOiIyMDI0LTEyLTI1VDEwOjAwOjAwIn0="), @Parameter(name="size", description="\ud398\uc774\uc9c0 \ud06c\uae30 (1-50, \uae30\ubcf8\uac12: 10)", example="10", schema=@Schema(type="integer", minimum="1", maximum="50"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc870\ud68c \uc131\uacf5", content={@Content(schema=@Schema(implementation=FreeboardCursorResponse.class), examples={@ExampleObject(value="{\"posts\":[{\"postId\":101,\"author\":{\"userId\":\"author101\",\"nickname\":\"\uc791\uc131\uc790\",\"profileImageUrl\":\"https://cdn.example.com/profile.jpg\",\"userType\":\"INHABITANT\"},\"category\":\"restaurant\",\"title\":\"\ud14c\uc2a4\ud2b8 \uc81c\ubaa9\",\"contentPreview\":\"\ud14c\uc2a4\ud2b8 \ub0b4\uc6a9 \ubbf8\ub9ac\ubcf4\uae30...\",\"thumbnailUrl\":null,\"imageCount\":1,\"likeCount\":5,\"commentCount\":2,\"viewCount\":80,\"isLiked\":false,\"createdAt\":\"2025-01-01T10:00:00\",\"updatedAt\":null}],\"hasNext\":true,\"nextCursor\":\"eyJpZCI6MTAxLCJzb3J0VmFsdWUiOiIyMDI1LTAxLTAxVDEwOjAwOjAwIn0=\",\"size\":1,\"totalCount\":20}")})}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \ud30c\ub77c\ubbf8\ud130", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc798\ubabb\ub41c \uce74\ud14c\uace0\ub9ac", value="{\"code\": \"INVALID_CATEGORY\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uce74\ud14c\uace0\ub9ac\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \uc815\ub82c \uac12", value="{\"code\": \"INVALID_ENUM_VALUE\", \"message\": \"'INVALID_SORT'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [LATEST, LIKE, COMMENT, VIEW]\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \ucee4\uc11c", value="{\"code\": \"INVALID_CURSOR\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ucee4\uc11c \uac12\uc785\ub2c8\ub2e4.\"}")})})})
    @GetMapping
    public ResponseEntity<?> getPostsByCursor(@RequestParam(value="category", required=false) Category category, @RequestParam(defaultValue="LATEST") FreeboardSortType sort, @RequestParam(required=false) String cursor, @RequestParam(defaultValue="10") int size) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String userId = null;
        if (authentication != null && authentication.isAuthenticated() && !"anonymousUser".equals(authentication.getPrincipal()) && authentication.getPrincipal() instanceof CustomUserDetails) {
            CustomUserDetails userDetails = (CustomUserDetails)authentication.getPrincipal();
            userId = userDetails.getUser().getId();
        }
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \ubaa9\ub85d \uc870\ud68c \uc694\uccad: category={}, sort={}, cursor={}, size={}, userId={}", new Object[]{category, sort, cursor != null ? "present" : "null", size, userId != null ? userId : "anonymous"});
        try {
            FreeboardCursorResponse response = this.freeboardService.getPostsByCursor(category, sort, size, cursor, userId);
            log.debug("\uc790\uc720\uac8c\uc2dc\ud310 \ubaa9\ub85d \uc870\ud68c \uc644\ub8cc: resultCount={}, hasNext={}", (Object)response.getPosts().size(), (Object)response.isHasNext());
            return ResponseEntity.ok((Object)response);
        }
        catch (PostException e) {
            log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \ubaa9\ub85d \uc870\ud68c \uc911 \ube44\uc988\ub2c8\uc2a4 \uc608\uc678: category={}, sort={}, cursor={}, size={}, userId={}, error={}", new Object[]{category, sort, cursor, size, userId, e.getMessage()});
            throw e;
        }
        catch (Exception e) {
            log.error("\uc790\uc720\uac8c\uc2dc\ud310 \ubaa9\ub85d \uc870\ud68c \uc911 \uc608\uae30\uce58 \ubabb\ud55c \uc608\uc678: category={}, sort={}, cursor={}, size={}, userId={}", new Object[]{category, sort, cursor, size, userId, e});
            throw e;
        }
    }

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc218\uc815", description="\uc791\uc131\ud55c \uac8c\uc2dc\uae00\uc744 \uc218\uc815\ud569\ub2c8\ub2e4.\n\n**\uc218\uc815 \uac00\ub2a5 \ud56d\ubaa9:**\n- \uc81c\ubaa9\n- \ub0b4\uc6a9\n- \uce74\ud14c\uace0\ub9ac\n- \uc774\ubbf8\uc9c0 (\uae30\uc874 \uc774\ubbf8\uc9c0 \uad50\uccb4 \uac00\ub2a5)\n\n**\uad8c\ud55c:** \uc791\uc131\uc790 \ubcf8\uc778\ub9cc \uc218\uc815 \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\uc218\uc815 \uc131\uacf5", content={@Content(schema=@Schema(implementation=FreeboardCreateResponse.class))}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad (\uac80\uc99d \uc2e4\ud328, \uc774\ubbf8\uc9c0 \uad00\ub828 \uc624\ub958)", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ube48 \uc81c\ubaa9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[title] \uc81c\ubaa9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\ube48 \ub0b4\uc6a9", value="{\"code\": \"VALIDATION_FAILED\", \"message\": \"[content] \ub0b4\uc6a9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \uce74\ud14c\uace0\ub9ac", value="{\"code\": \"INVALID_ENUM_VALUE\", \"message\": \"'invalid-category'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [daily-hobby, restaurant, living-convenience, neighborhood-news, startup, others]\"}"), @ExampleObject(name="\uc774\ubbf8\uc9c0 \uac1c\uc218 \ucd08\uacfc", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc774\ubbf8\uc9c0\ub294 \ucd5c\ub300 4\uc7a5\uae4c\uc9c0 \uc5c5\ub85c\ub4dc \uac00\ub2a5\ud569\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c \ud615\uc2dd", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c \ud615\uc2dd\uc785\ub2c8\ub2e4. \uc9c0\uc6d0 \ud615\uc2dd: image/jpeg, image/jpg, image/png, image/gif, image/webp\"}"), @ExampleObject(name="\ube48 \ud30c\uc77c", value="{\"code\": \"ILLEGAL_ARGUMENT\", \"message\": \"\uc774\ubbf8\uc9c0 \ud30c\uc77c\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="413", description="\ud30c\uc77c \ud06c\uae30 \ucd08\uacfc (Spring multipart \uc81c\ud55c)", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"FILE_SIZE_EXCEEDED\", \"message\": \"\ud30c\uc77c \ud06c\uae30\uac00 \ub108\ubb34 \ud07d\ub2c8\ub2e4. \ucd5c\ub300 \uc5c5\ub85c\ub4dc \ud06c\uae30\ub294 5MB\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="403", description="\uad8c\ud55c \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_ACCESS_DENIED\", \"message\": \"\uac8c\uc2dc\uae00\uc5d0 \ub300\ud55c \uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @PatchMapping(value={"/{freeboardId}"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> updatePost(@Parameter(description="\uc218\uc815\ud560 \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long freeboardId, @ModelAttribute @Valid FreeboardUpdateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc218\uc815 \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: freeboardId={}", (Object)freeboardId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc218\uc815 \uc694\uccad: freeboardId={}, userId={}", (Object)freeboardId, (Object)userDetails.getUser().getId());
        String userId = userDetails.getUser().getId();
        FreeboardCreateResponse response = this.freeboardService.updatePost(freeboardId, request, userId);
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc218\uc815 \uc644\ub8cc: freeboardId={}", (Object)response.getPostId());
        return ResponseEntity.ok((Object)response);
    }

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc0ad\uc81c (\uc18c\ud504\ud2b8 \uc0ad\uc81c)", description="\uac8c\uc2dc\uae00\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4. (\uc18c\ud504\ud2b8 \uc0ad\uc81c)\n\n**\uc0ad\uc81c \ud2b9\uc9d5:**\n- \uc2e4\uc81c\ub85c\ub294 deleted \ud50c\ub798\uadf8\ub9cc true\ub85c \ubcc0\uacbd\n- \ub313\uae00 \ubc0f \uc88b\uc544\uc694 \uc815\ubcf4\ub294 \ubcf4\uc874\n- \uad00\ub9ac\uc790\ub294 \ubcf5\uad6c \uac00\ub2a5\n\n**\uad8c\ud55c:** \uc791\uc131\uc790 \ubcf8\uc778\ub9cc \uc0ad\uc81c \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="\uc0ad\uc81c \uc131\uacf5"), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="403", description="\uc0ad\uc81c \uad8c\ud55c \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_ACCESS_DENIED\", \"message\": \"\uac8c\uc2dc\uae00\uc5d0 \ub300\ud55c \uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @DeleteMapping(value={"/{freeboardId}"})
    public ResponseEntity<?> deletePost(@Parameter(description="\uc0ad\uc81c\ud560 \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long freeboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc0ad\uc81c \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: freeboardId={}", (Object)freeboardId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc0ad\uc81c \uc694\uccad: freeboardId={}, userId={}", (Object)freeboardId, (Object)userDetails.getUser().getId());
        String userId = userDetails.getUser().getId();
        this.freeboardService.deletePost(freeboardId, userId);
        log.info("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc0ad\uc81c \uc644\ub8cc: freeboardId={}", (Object)freeboardId);
        return ResponseEntity.noContent().build();
    }

    @Operation(summary="\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc601\uad6c \uc0ad\uc81c", description="\uac8c\uc2dc\uae00\uc744 \uc601\uad6c\uc801\uc73c\ub85c \uc0ad\uc81c\ud569\ub2c8\ub2e4. (\ud558\ub4dc \uc0ad\uc81c)\n\n**\uc8fc\uc758\uc0ac\ud56d:**\n- \ubcf5\uad6c \ubd88\uac00\ub2a5\ud55c \uc0ad\uc81c\n- \uad00\ub828\ub41c \ub313\uae00, \uc88b\uc544\uc694, \uc774\ubbf8\uc9c0 \ubaa8\ub450 \uc0ad\uc81c\n- \uad00\ub9ac\uc790 \uad8c\ud55c \ud544\uc694\n")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="\uc601\uad6c \uc0ad\uc81c \uc131\uacf5"), @ApiResponse(responseCode="401", description="\uc778\uc99d \uc2e4\ud328", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"AUTHENTICATION_FAILED\", \"message\": \"\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="403", description="\uad00\ub9ac\uc790 \uad8c\ud55c \ud544\uc694", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_ACCESS_DENIED\", \"message\": \"\uac8c\uc2dc\uae00\uc5d0 \ub300\ud55c \uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    @DeleteMapping(value={"/{freeboardId}/force"})
    public ResponseEntity<?> hardDeletePost(@Parameter(description="\uc601\uad6c \uc0ad\uc81c\ud560 \uac8c\uc2dc\uae00 ID", example="123") @PathVariable Long freeboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        if (userDetails == null) {
            log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc601\uad6c \uc0ad\uc81c \uc694\uccad \uc2dc \uc778\uc99d \uc815\ubcf4 \uc5c6\uc74c: freeboardId={}", (Object)freeboardId);
            ErrorResponse errorResponse = new ErrorResponse("AUTHENTICATION_FAILED", "\uc778\uc99d\uc774 \ud544\uc694\ud569\ub2c8\ub2e4.");
            return ResponseEntity.status((int)401).body((Object)errorResponse);
        }
        log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc601\uad6c \uc0ad\uc81c \uc694\uccad: freeboardId={}, userId={}", (Object)freeboardId, (Object)userDetails.getUser().getId());
        String userId = userDetails.getUser().getId();
        this.freeboardService.hardDeletePost(freeboardId, userId);
        log.warn("\uc790\uc720\uac8c\uc2dc\ud310 \uae00 \uc601\uad6c \uc0ad\uc81c \uc644\ub8cc: freeboardId={}", (Object)freeboardId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public FreeboardController(FreeboardService freeboardService) {
        this.freeboardService = freeboardService;
    }
}

