/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.repository;

import com.example.soso.community.voteboard.domain.entity.VotePost;
import com.example.soso.users.domain.entity.Users;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface VotePostRepository
extends JpaRepository<VotePost, Long> {
    @Query(value="SELECT vp FROM VotePost vp WHERE vp.id = :id AND vp.deleted = false")
    public Optional<VotePost> findByIdAndDeletedFalse(@Param(value="id") Long var1);

    @Query(value="SELECT vp FROM VotePost vp WHERE vp.deleted = false AND vp.id < :cursor ORDER BY vp.id DESC")
    public List<VotePost> findAllByCursorWithoutStatus(@Param(value="cursor") Long var1, Pageable var2);

    @Query(value="SELECT vp FROM VotePost vp WHERE vp.deleted = false ORDER BY vp.id DESC")
    public List<VotePost> findAllWithoutStatus(Pageable var1);

    @Query(value="SELECT vp FROM VotePost vp WHERE vp.deleted = false AND vp.endTime > :now AND vp.id < :cursor ORDER BY vp.id DESC")
    public List<VotePost> findInProgressByCursor(@Param(value="cursor") Long var1, @Param(value="now") LocalDateTime var2, Pageable var3);

    @Query(value="SELECT vp FROM VotePost vp WHERE vp.deleted = false AND vp.endTime > :now ORDER BY vp.id DESC")
    public List<VotePost> findInProgress(@Param(value="now") LocalDateTime var1, Pageable var2);

    @Query(value="SELECT vp FROM VotePost vp WHERE vp.deleted = false AND vp.endTime <= :now AND vp.id < :cursor ORDER BY vp.id DESC")
    public List<VotePost> findCompletedByCursor(@Param(value="cursor") Long var1, @Param(value="now") LocalDateTime var2, Pageable var3);

    @Query(value="SELECT vp FROM VotePost vp WHERE vp.deleted = false AND vp.endTime <= :now ORDER BY vp.id DESC")
    public List<VotePost> findCompleted(@Param(value="now") LocalDateTime var1, Pageable var2);

    public long countByUserAndDeletedFalse(Users var1);

    public long countByDeletedFalse();

    @Query(value="SELECT COUNT(vp) FROM VotePost vp WHERE vp.deleted = false AND vp.endTime > :now")
    public long countInProgress(@Param(value="now") LocalDateTime var1);

    @Query(value="SELECT COUNT(vp) FROM VotePost vp WHERE vp.deleted = false AND vp.endTime <= :now")
    public long countCompleted(@Param(value="now") LocalDateTime var1);
}

