/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.security.filter;

import com.example.soso.global.jwt.JwtProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=1)
@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    private final JwtProvider jwtProvider;
    private final UserDetailsService userDetailsService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String token = this.resolveToken(request);
            if (StringUtils.hasText((String)token)) {
                if (this.jwtProvider.validateToken(token)) {
                    this.setAuthentication(token);
                } else {
                    log.warn("\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 JWT \ud1a0\ud070: {}", (Object)request.getRequestURI());
                    SecurityContextHolder.clearContext();
                }
            }
        }
        catch (Exception e) {
            log.error("JWT \ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd: {}", (Object)e.getMessage());
            SecurityContextHolder.clearContext();
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String resolveToken(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }

    private void setAuthentication(String token) {
        try {
            String userId = this.jwtProvider.getSubject(token);
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(userId);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            log.debug("JWT \uc778\uc99d \uc131\uacf5: {}", (Object)userId);
        }
        catch (UsernameNotFoundException e) {
            log.warn("\uc0ac\uc6a9\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c: {}", (Object)e.getMessage());
            SecurityContextHolder.clearContext();
        }
        catch (Exception e) {
            log.error("\uc778\uc99d \uc124\uc815 \uc911 \uc624\ub958: {}", (Object)e.getMessage());
            SecurityContextHolder.clearContext();
        }
    }

    @Generated
    public JwtAuthenticationFilter(JwtProvider jwtProvider, UserDetailsService userDetailsService) {
        this.jwtProvider = jwtProvider;
        this.userDetailsService = userDetailsService;
    }
}

