/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.domain.entity;

import com.example.soso.community.voteboard.domain.entity.VoteOption;
import com.example.soso.community.voteboard.domain.entity.VotePost;
import com.example.soso.community.voteboard.domain.entity.VoteResult;
import com.example.soso.global.time.BaseTimeEntity;
import com.example.soso.users.domain.entity.Users;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import lombok.Generated;

@Entity
@Table(name="vote_result", uniqueConstraints={@UniqueConstraint(name="uk_vote_result_user_post", columnNames={"user_id", "vote_post_id"})}, indexes={@Index(name="idx_vote_result_user", columnList="user_id"), @Index(name="idx_vote_result_post", columnList="vote_post_id")})
public class VoteResult
extends BaseTimeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_id", nullable=false)
    private Users user;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="vote_post_id", nullable=false)
    private VotePost votePost;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="vote_option_id", nullable=false)
    private VoteOption voteOption;

    public VoteResult(Users user, VotePost votePost, VoteOption voteOption) {
        this.user = user;
        this.votePost = votePost;
        this.voteOption = voteOption;
    }

    public void changeVote(VoteOption newOption) {
        this.voteOption.decreaseVoteCount();
        this.voteOption = newOption;
        newOption.increaseVoteCount();
    }

    @Generated
    public static VoteResultBuilder builder() {
        return new VoteResultBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Users getUser() {
        return this.user;
    }

    @Generated
    public VotePost getVotePost() {
        return this.votePost;
    }

    @Generated
    public VoteOption getVoteOption() {
        return this.voteOption;
    }

    @Generated
    protected VoteResult() {
    }
}

