/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=0)
@Component
public class ExceptionHandlerFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerFilter.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ExpiredJwtException e) {
            log.info("AccessToken \ub9cc\ub8cc\ub428");
            this.setErrorResponse(response, 401, "ACCESS_TOKEN_EXPIRED");
        }
        catch (JwtException e) {
            log.warn("JWT \uc608\uc678 \ubc1c\uc0dd: {}", (Object)e.getMessage());
            this.setErrorResponse(response, 401, "INVALID_TOKEN");
        }
        catch (AuthenticationException e) {
            log.warn("\uc778\uc99d \uc608\uc678 \ubc1c\uc0dd: {}", (Object)e.getMessage());
            this.setErrorResponse(response, 401, "\uc778\uc99d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        catch (Exception e) {
            log.error("\uc11c\ubc84 \ub0b4\ubd80 \uc624\ub958 \ubc1c\uc0dd: {}", (Object)e.getMessage(), (Object)e);
            this.setErrorResponse(response, 500, "\uc11c\ubc84 \ub0b4\ubd80 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setErrorResponse(HttpServletResponse response, int status, String message) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json; charset=UTF-8");
        HashMap<String, Object> errorBody = new HashMap<String, Object>();
        errorBody.put("code", status);
        errorBody.put("message", message);
        this.objectMapper.writeValue((Writer)response.getWriter(), errorBody);
    }
}

