/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.common.likes.service;

import com.example.soso.community.common.likes.dto.PostLikeResponse;
import com.example.soso.global.redis.PostLikeRedisRepository;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class PostLikeService {
    private final PostLikeRedisRepository redisRepository;

    public PostLikeResponse likePost(Long postId, String userId) {
        boolean liked = false;
        if (!this.redisRepository.isLiked(postId, userId)) {
            this.redisRepository.addLike(postId, userId);
            liked = true;
        } else {
            liked = true;
        }
        long count = this.redisRepository.getLikeCount(postId);
        return new PostLikeResponse(liked, count);
    }

    public PostLikeResponse unlikePost(Long postId, String userId) {
        boolean liked = this.redisRepository.isLiked(postId, userId);
        if (liked) {
            this.redisRepository.removeLike(postId, userId);
        }
        long count = this.redisRepository.getLikeCount(postId);
        return new PostLikeResponse(false, count);
    }

    public boolean isPostLiked(Long postId, String userId) {
        return this.redisRepository.isLiked(postId, userId);
    }

    public long getPostLikeCount(Long postId) {
        return this.redisRepository.getLikeCount(postId);
    }

    @Generated
    public PostLikeService(PostLikeRedisRepository redisRepository) {
        this.redisRepository = redisRepository;
    }
}

