/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.redis;

import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.PostErrorCode;
import com.example.soso.global.exception.util.PostException;
import lombok.Generated;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class CommentLikeRedisRepository {
    private final RedisTemplate<String, String> redisTemplate;

    private String getSetKey(Long commentId) {
        return "like:comment:set:" + commentId;
    }

    private String getCountKey(Long commentId) {
        return "like:comment:count:" + commentId;
    }

    public void addLike(Long commentId, String userId) {
        this.redisTemplate.opsForSet().add((Object)this.getSetKey(commentId), (Object[])new String[]{userId});
        this.redisTemplate.opsForValue().increment((Object)this.getCountKey(commentId));
    }

    public void removeLike(Long commentId, String userId) {
        this.redisTemplate.opsForSet().remove((Object)this.getSetKey(commentId), new Object[]{userId});
        this.redisTemplate.opsForValue().decrement((Object)this.getCountKey(commentId));
    }

    public boolean isLiked(Long commentId, String userId) {
        return Boolean.TRUE.equals(this.redisTemplate.opsForSet().isMember((Object)this.getSetKey(commentId), (Object)userId));
    }

    public long getLikeCount(Long commentId) {
        String count = (String)this.redisTemplate.opsForValue().get((Object)this.getCountKey(commentId));
        if (count == null) {
            throw new PostException((BaseErrorCode)PostErrorCode.LIKE_COUNT_NOT_FOUND);
        }
        return Long.parseLong(count);
    }

    @Generated
    public CommentLikeRedisRepository(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

