/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.domain.entity;

import com.example.soso.community.voteboard.domain.entity.VoteOption;
import com.example.soso.community.voteboard.domain.entity.VotePost;
import com.example.soso.global.time.BaseTimeEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="vote_option")
public class VoteOption
extends BaseTimeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="vote_post_id", nullable=false)
    private VotePost votePost;
    @Column(name="content", nullable=false, length=100)
    private String content;
    @Column(name="sequence", nullable=false)
    private int sequence;
    @Column(name="vote_count", nullable=false)
    private int voteCount = 0;

    public VoteOption(VotePost votePost, String content, int sequence) {
        this.votePost = votePost;
        this.content = content;
        this.sequence = sequence;
        this.voteCount = 0;
    }

    public void setVotePost(VotePost votePost) {
        this.votePost = votePost;
    }

    public void increaseVoteCount() {
        ++this.voteCount;
    }

    public void decreaseVoteCount() {
        if (this.voteCount > 0) {
            --this.voteCount;
        }
    }

    public double calculatePercentage(int totalVotes) {
        if (totalVotes == 0) {
            return 0.0;
        }
        return (double)this.voteCount / (double)totalVotes * 100.0;
    }

    @Generated
    public static VoteOptionBuilder builder() {
        return new VoteOptionBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public VotePost getVotePost() {
        return this.votePost;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public int getSequence() {
        return this.sequence;
    }

    @Generated
    public int getVoteCount() {
        return this.voteCount;
    }

    @Generated
    protected VoteOption() {
    }
}

