/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.security.config;

import com.example.soso.security.filter.ExceptionHandlerFilter;
import com.example.soso.security.filter.JwtAuthenticationFilter;
import jakarta.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JwtSecurityDsl
extends AbstractHttpConfigurer<JwtSecurityDsl, HttpSecurity> {
    private boolean enabled;

    public void init(HttpSecurity http) throws Exception {
    }

    public void configure(HttpSecurity http) throws Exception {
        if (!this.enabled) {
            return;
        }
        ApplicationContext context = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        JwtAuthenticationFilter jwtFilter = (JwtAuthenticationFilter)context.getBean(JwtAuthenticationFilter.class);
        ExceptionHandlerFilter exFilter = (ExceptionHandlerFilter)context.getBean(ExceptionHandlerFilter.class);
        http.addFilterBefore((Filter)exFilter, UsernamePasswordAuthenticationFilter.class);
        http.addFilterBefore((Filter)jwtFilter, UsernamePasswordAuthenticationFilter.class);
    }

    public JwtSecurityDsl enable(boolean enable) {
        this.enabled = enable;
        return this;
    }

    public static JwtSecurityDsl customDsl() {
        return new JwtSecurityDsl();
    }
}

