/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.community.voteboard.controller;

import com.example.soso.community.voteboard.domain.dto.VotePostCreateRequest;
import com.example.soso.community.voteboard.domain.dto.VotePostDetailResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostIdResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostListResponse;
import com.example.soso.community.voteboard.domain.dto.VotePostUpdateRequest;
import com.example.soso.community.voteboard.domain.dto.VoteRequest;
import com.example.soso.community.voteboard.domain.entity.VoteStatus;
import com.example.soso.community.voteboard.service.VotePostService;
import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.security.domain.CustomUserDetails;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/community/votesboard"})
@Tag(name="Voteboard", description="\ud22c\ud45c \uac8c\uc2dc\ud310 API")
public class VoteboardController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoteboardController.class);
    private final VotePostService votePostService;

    @PostMapping
    @Operation(summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131", description="\uc0c8\ub85c\uc6b4 \ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \uc791\uc131\ud569\ub2c8\ub2e4.\n\n**\uc81c\uc57d\uc0ac\ud56d:**\n- \ud22c\ud45c \uc635\uc158: \ucd5c\uc18c 2\uac1c, \ucd5c\ub300 5\uac1c\n- \uc81c\ubaa9: \ucd5c\ub300 100\uc790\n- \ub0b4\uc6a9: \ucd5c\ub300 5000\uc790\n- \uc774\ubbf8\uc9c0: \ucd5c\ub300 5\uac1c\n- \ub9c8\uac10 \uc2dc\uac04: \ud604\uc7ac \uc2dc\uac04\ubcf4\ub2e4 \ubbf8\ub798\uc5ec\uc57c \ud568\n\n**\uad8c\ud55c:** \ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790\ub9cc \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc791\uc131 \uc131\uacf5", content={@Content(mediaType="application/json", schema=@Schema(implementation=VotePostIdResponse.class), examples={@ExampleObject(name="\uc131\uacf5 \uc751\ub2f5", value="{\"votesboardId\": 1}")})}), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc635\uc158 \uac1c\uc218 \ubd80\uc871", value="{\"code\": \"BAD_REQUEST\", \"message\": \"\ud22c\ud45c \uc635\uc158\uc740 \ucd5c\uc18c 2\uac1c, \ucd5c\ub300 5\uac1c\uae4c\uc9c0 \uac00\ub2a5\ud569\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uacfc\uac70 \ub9c8\uac10 \uc2dc\uac04", value="{\"code\": \"BAD_REQUEST\", \"message\": \"\ud22c\ud45c \ub9c8\uac10 \uc2dc\uac04\uc740 \ubbf8\ub798 \uc2dc\uac04\uc774\uc5b4\uc57c \ud569\ub2c8\ub2e4.\"}"), @ExampleObject(name="\ud544\uc218 \ud544\ub4dc \ub204\ub77d", value="{\"code\": \"BAD_REQUEST\", \"message\": \"\uc81c\ubaa9\uc740 \ud544\uc218\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="401", description="\uc778\uc99d\ub418\uc9c0 \uc54a\uc740 \uc0ac\uc6a9\uc790", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc778\uc99d \uc2e4\ud328", value="{\"code\": \"UNAUTHORIZED\", \"message\": \"\uc778\uc99d\ub418\uc9c0 \uc54a\uc740 \uc0ac\uc6a9\uc790\uc785\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<VotePostIdResponse> createVotePost(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0dd\uc131 \uc815\ubcf4", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=VotePostCreateRequest.class), examples={@ExampleObject(name="\ud22c\ud45c \uc0dd\uc131 \uc608\uc2dc", value="{\n  \"title\": \"\uc810\uc2ec \uba54\ub274 \ud22c\ud45c\",\n  \"content\": \"\uc624\ub298 \uc810\uc2ec \ubb50 \uba39\uc744\uae4c\uc694?\",\n  \"imageUrls\": [\"https://example.com/food.jpg\"],\n  \"voteOptions\": [\n    {\"content\": \"\ud55c\uc2dd\"},\n    {\"content\": \"\uc911\uc2dd\"},\n    {\"content\": \"\uc77c\uc2dd\"}\n  ],\n  \"endTime\": \"2025-12-31T12:00:00\",\n  \"allowRevote\": true\n}\n")})}) @Valid @RequestBody VotePostCreateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        Long votesboardId = this.votePostService.createVotePost(request, userDetails.getUser().getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)new VotePostIdResponse(votesboardId));
    }

    @GetMapping(value={"/{votesboardId}"})
    @Operation(summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0c1\uc138 \uc870\ud68c", description="\ud22c\ud45c \uac8c\uc2dc\uae00\uc758 \uc0c1\uc138 \uc815\ubcf4\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4. \ube44\ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790\ub3c4 \uc870\ud68c \uac00\ub2a5\ud569\ub2c8\ub2e4.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc870\ud68c \uc131\uacf5", content={@Content(mediaType="application/json", schema=@Schema(implementation=VotePostDetailResponse.class))}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<VotePostDetailResponse> getVotePost(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        String userId = userDetails != null ? userDetails.getUser().getId() : null;
        VotePostDetailResponse response = this.votePostService.getVotePost(votesboardId, userId);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping
    @Operation(summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d \uc870\ud68c (\ucee4\uc11c \uae30\ubc18)", description="\ucee4\uc11c \uae30\ubc18 \ud398\uc774\uc9c0\ub124\uc774\uc158\uc73c\ub85c \ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d\uc744 \uc870\ud68c\ud569\ub2c8\ub2e4.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \ubaa9\ub85d \uc870\ud68c \uc131\uacf5", content={@Content(mediaType="application/json", schema=@Schema(implementation=VotePostListResponse.class))})})
    public ResponseEntity<VotePostListResponse> getVotePostList(@Parameter(description="\ud22c\ud45c \uc0c1\ud0dc (IN_PROGRESS: \uc9c4\ud589\uc911, COMPLETED: \uc644\ub8cc, null: \uc804\uccb4)") @RequestParam(required=false) VoteStatus status, @Parameter(description="\ud398\uc774\uc9c0 \ud06c\uae30", example="20") @RequestParam(defaultValue="20") int size, @Parameter(description="\ucee4\uc11c (\uc774\uc804 \ud398\uc774\uc9c0\uc758 \ub9c8\uc9c0\ub9c9 \uac8c\uc2dc\uae00 ID)") @RequestParam(required=false) Long cursor, @Parameter(hidden=true) @AuthenticationPrincipal CustomUserDetails userDetails) {
        String userId = userDetails != null ? userDetails.getUser().getId() : null;
        VotePostListResponse response = this.votePostService.getVotePostsByCursor(status, size, cursor, userId);
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/{votesboardId}"})
    @Operation(summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815", description="\ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \uc218\uc815\ud569\ub2c8\ub2e4. \ud22c\ud45c \uc635\uc158\uc740 \uc218\uc815\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc218\uc815 \uc131\uacf5"), @ApiResponse(responseCode="403", description="\uad8c\ud55c \uc5c6\uc74c (\uc791\uc131\uc790\uac00 \uc544\ub2d8)", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED_ACCESS\", \"message\": \"\uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> updateVotePost(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @Valid @RequestBody VotePostUpdateRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votePostService.updateVotePost(votesboardId, request, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{votesboardId}"})
    @Operation(summary="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c", description="\ud22c\ud45c \uac8c\uc2dc\uae00\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4 (\uc18c\ud504\ud2b8 \uc0ad\uc81c).")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \uac8c\uc2dc\uae00 \uc0ad\uc81c \uc131\uacf5"), @ApiResponse(responseCode="403", description="\uad8c\ud55c \uc5c6\uc74c (\uc791\uc131\uc790\uac00 \uc544\ub2d8)", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"UNAUTHORIZED_ACCESS\", \"message\": \"\uc811\uadfc \uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> deleteVotePost(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votePostService.deleteVotePost(votesboardId, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{votesboardId}/vote"})
    @Operation(summary="\ud22c\ud45c \ucc38\uc5ec", description="\ud22c\ud45c\uc5d0 \ucc38\uc5ec\ud569\ub2c8\ub2e4.\n\n**\uc81c\uc57d\uc0ac\ud56d:**\n- \ud55c \ud22c\ud45c\ub2f9 1\ubc88\ub9cc \ucc38\uc5ec \uac00\ub2a5 (\uc911\ubcf5 \ud22c\ud45c \ubd88\uac00)\n- \uc9c4\ud589 \uc911\uc778 \ud22c\ud45c\uc5d0\ub9cc \ucc38\uc5ec \uac00\ub2a5\n- \uc120\ud0dd\ud55c \uc635\uc158\uc740 \ud574\ub2f9 \ud22c\ud45c\uc758 \uc635\uc158\uc774\uc5b4\uc57c \ud568\n\n**\uad8c\ud55c:** \ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790\ub9cc \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \ucc38\uc5ec \uc131\uacf5"), @ApiResponse(responseCode="400", description="\uc798\ubabb\ub41c \uc694\uccad", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ud22c\ud45c \ub9c8\uac10", value="{\"code\": \"VOTE_CLOSED\", \"message\": \"\ud22c\ud45c\uac00 \ub9c8\uac10\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\"}"), @ExampleObject(name="\uc798\ubabb\ub41c \uc635\uc158", value="{\"code\": \"INVALID_VOTE_OPTION\", \"message\": \"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \ud22c\ud45c \uc635\uc158\uc785\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="409", description="\uc774\ubbf8 \ud22c\ud45c\uc5d0 \ucc38\uc5ec\ud568", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc911\ubcf5 \ud22c\ud45c", value="{\"code\": \"ALREADY_VOTED\", \"message\": \"\uc774\ubbf8 \ud22c\ud45c\uc5d0 \ucc38\uc5ec\ud558\uc600\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\uac8c\uc2dc\uae00 \ub610\ub294 \uc635\uc158\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uac8c\uc2dc\uae00 \uc5c6\uc74c", value="{\"code\": \"POST_NOT_FOUND\", \"message\": \"\ud574\ub2f9 \uac8c\uc2dc\uae00\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> vote(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true, example="1") @PathVariable Long votesboardId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="\ud22c\ud45c \uc635\uc158 \uc120\ud0dd \uc815\ubcf4", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=VoteRequest.class), examples={@ExampleObject(name="\ud22c\ud45c \ucc38\uc5ec \uc608\uc2dc", value="{\"voteOptionId\": 2}")})}) @Valid @RequestBody VoteRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votePostService.vote(votesboardId, request, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{votesboardId}/vote"})
    @Operation(summary="\ud22c\ud45c \ubcc0\uacbd (\uc7ac\ud22c\ud45c)", description="\uc774\ubbf8 \ucc38\uc5ec\ud55c \ud22c\ud45c\ub97c \ubcc0\uacbd\ud569\ub2c8\ub2e4.\n\n**\uc81c\uc57d\uc0ac\ud56d:**\n- \uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub41c \uacbd\uc6b0\uc5d0\ub9cc \uac00\ub2a5 (allowRevote = true)\n- \uc9c4\ud589 \uc911\uc778 \ud22c\ud45c\uc5d0\ub9cc \uac00\ub2a5\n- \uae30\uc874\uc5d0 \ud22c\ud45c\ud55c \uae30\ub85d\uc774 \uc788\uc5b4\uc57c \ud568\n\n**\uad8c\ud55c:** \ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790\ub9cc \uac00\ub2a5\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \ubcc0\uacbd \uc131\uacf5"), @ApiResponse(responseCode="400", description="\ud22c\ud45c \ub9c8\uac10", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ud22c\ud45c \ub9c8\uac10", value="{\"code\": \"VOTE_CLOSED\", \"message\": \"\ud22c\ud45c\uac00 \ub9c8\uac10\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="403", description="\uc7ac\ud22c\ud45c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\uc7ac\ud22c\ud45c \ubd88\uac00", value="{\"code\": \"REVOTE_NOT_ALLOWED\", \"message\": \"\uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(name="\ud22c\ud45c \uae30\ub85d \uc5c6\uc74c", value="{\"code\": \"VOTE_NOT_FOUND\", \"message\": \"\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> changeVote(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true, example="1") @PathVariable Long votesboardId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="\uc0c8\ub85c \uc120\ud0dd\ud560 \ud22c\ud45c \uc635\uc158 \uc815\ubcf4", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=VoteRequest.class), examples={@ExampleObject(name="\uc7ac\ud22c\ud45c \uc608\uc2dc", value="{\"voteOptionId\": 3}", description="\ud55c\uc2dd(1) \u2192 \uc77c\uc2dd(3)\uc73c\ub85c \ubcc0\uacbd")})}) @Valid @RequestBody VoteRequest request, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votePostService.changeVote(votesboardId, request, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{votesboardId}/vote"})
    @Operation(summary="\ud22c\ud45c \ucde8\uc18c", description="\ucc38\uc5ec\ud55c \ud22c\ud45c\ub97c \ucde8\uc18c\ud569\ub2c8\ub2e4. \uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub41c \uacbd\uc6b0\uc5d0\ub9cc \uac00\ub2a5\ud569\ub2c8\ub2e4.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\ud22c\ud45c \ucde8\uc18c \uc131\uacf5"), @ApiResponse(responseCode="403", description="\uc7ac\ud22c\ud45c \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"REVOTE_NOT_ALLOWED\", \"message\": \"\uc7ac\ud22c\ud45c\uac00 \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.\"}")})}), @ApiResponse(responseCode="404", description="\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc74c", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class), examples={@ExampleObject(value="{\"code\": \"VOTE_NOT_FOUND\", \"message\": \"\ud22c\ud45c \uae30\ub85d\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.\"}")})})})
    public ResponseEntity<Void> cancelVote(@Parameter(description="\ud22c\ud45c \uac8c\uc2dc\uae00 ID", required=true) @PathVariable Long votesboardId, @AuthenticationPrincipal CustomUserDetails userDetails) {
        this.votePostService.cancelVote(votesboardId, userDetails.getUser().getId());
        return ResponseEntity.ok().build();
    }

    @Generated
    public VoteboardController(VotePostService votePostService) {
        this.votePostService = votePostService;
    }
}

