/*
 * Decompiled with CFR 0.152.
 */
package com.example.soso.global.exception;

import com.example.soso.global.exception.domain.BaseErrorCode;
import com.example.soso.global.exception.domain.ErrorResponse;
import com.example.soso.global.exception.util.BaseException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import feign.FeignException;
import java.util.Arrays;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BaseException.class})
    public ResponseEntity<ErrorResponse> handleBaseException(BaseException ex) {
        BaseErrorCode errorCode = ex.getErrorCode();
        log.warn("Handled business exception: {} - {}", (Object)errorCode.name(), (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)errorCode.getHttpStatus()).body((Object)new ErrorResponse(errorCode.name(), errorCode.getMessage()));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<ErrorResponse> handleHttpMessageNotReadable(HttpMessageNotReadableException ex) {
        InvalidFormatException invalidFormatException;
        Throwable rootCause = ex.getMostSpecificCause();
        if (rootCause instanceof InvalidFormatException && (invalidFormatException = (InvalidFormatException)rootCause).getTargetType().isEnum()) {
            Class enumType = invalidFormatException.getTargetType();
            String invalidValue = String.valueOf(invalidFormatException.getValue());
            String allowedValues = Arrays.stream(enumType.getEnumConstants()).map(Object::toString).collect(Collectors.joining(", "));
            String message = String.format("'%s'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [%s]", invalidValue, allowedValues);
            log.warn("Invalid enum value received: enumType={}, invalidValue={}", (Object)enumType.getSimpleName(), (Object)invalidValue);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ErrorResponse("INVALID_ENUM_VALUE", message));
        }
        log.warn("Failed to read HTTP message: {}", (Object)(rootCause != null ? rootCause.getMessage() : ex.getMessage()));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ErrorResponse("INVALID_REQUEST_BODY", "\uc694\uccad \ubcf8\ubb38\uc744 \ud574\uc11d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public ResponseEntity<ErrorResponse> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException ex) {
        Class targetType = ex.getRequiredType();
        if (targetType != null && targetType.isEnum()) {
            String invalidValue = String.valueOf(ex.getValue());
            String allowedValues = Arrays.stream(targetType.getEnumConstants()).map(Object::toString).collect(Collectors.joining(", "));
            String message = String.format("'%s'\uc740(\ub294) \ud5c8\uc6a9\ub418\uc9c0 \uc54a\ub294 \uac12\uc785\ub2c8\ub2e4. \uc0ac\uc6a9 \uac00\ub2a5\ud55c \uac12: [%s]", invalidValue, allowedValues);
            log.warn("Invalid enum parameter: parameterName={}, enumType={}, invalidValue={}", new Object[]{ex.getName(), targetType.getSimpleName(), invalidValue});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ErrorResponse("INVALID_ENUM_VALUE", message));
        }
        log.warn("Method argument type mismatch: parameterName={}, expectedType={}, actualValue={}", new Object[]{ex.getName(), targetType, ex.getValue()});
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ErrorResponse("INVALID_PARAMETER_TYPE", "\uc798\ubabb\ub41c \ud30c\ub77c\ubbf8\ud130 \ud0c0\uc785\uc785\ub2c8\ub2e4."));
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<ErrorResponse> handleIllegalArgument(IllegalArgumentException ex) {
        log.warn("Illegal argument encountered: {}", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ErrorResponse("ILLEGAL_ARGUMENT", ex.getMessage()));
    }

    @ExceptionHandler(value={FeignException.class})
    public ResponseEntity<ErrorResponse> handleFeignException(FeignException ex) {
        int status = ex.status();
        String responseBody = ex.contentUTF8();
        log.error("External API call failed: status={}, method={}, url={}, response={}", new Object[]{status, ex.request().httpMethod(), ex.request().url(), responseBody});
        if (status >= 400 && status < 500) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ErrorResponse("EXTERNAL_API_CLIENT_ERROR", "\uc678\ubd80 API \ud638\ucd9c\uc774 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4. \uc694\uccad \uc815\ubcf4\ub97c \ud655\uc778\ud574\uc8fc\uc138\uc694."));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_GATEWAY).body((Object)new ErrorResponse("EXTERNAL_API_SERVER_ERROR", "\uc678\ubd80 \uc11c\ube44\uc2a4\uc640\uc758 \ud1b5\uc2e0 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc7a0\uc2dc \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574\uc8fc\uc138\uc694."));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ErrorResponse> handleValidationException(MethodArgumentNotValidException ex) {
        FieldError fieldError = ex.getBindingResult().getFieldError();
        Object message = fieldError != null ? "[" + fieldError.getField() + "] " + fieldError.getDefaultMessage() : "\uc798\ubabb\ub41c \uc694\uccad\uc785\ub2c8\ub2e4.";
        return ResponseEntity.badRequest().body((Object)new ErrorResponse("VALIDATION_FAILED", (String)message));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ResponseEntity<ErrorResponse> handleMaxUploadSizeExceeded(MaxUploadSizeExceededException ex) {
        String message;
        long maxFileSize = ex.getMaxUploadSize();
        if (maxFileSize > 0L) {
            long maxFileSizeMB = maxFileSize / 0x100000L;
            message = String.format("\ud30c\uc77c \ud06c\uae30\uac00 \ub108\ubb34 \ud07d\ub2c8\ub2e4. \ucd5c\ub300 \uc5c5\ub85c\ub4dc \ud06c\uae30\ub294 %dMB\uc785\ub2c8\ub2e4.", maxFileSizeMB);
        } else {
            message = "\ud30c\uc77c \ud06c\uae30\uac00 \ub108\ubb34 \ud07d\ub2c8\ub2e4. \uc5c5\ub85c\ub4dc \ud06c\uae30 \uc81c\ud55c\uc744 \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4.";
        }
        log.warn("File upload size exceeded: maxSize={}, message={}", (Object)maxFileSize, (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE).body((Object)new ErrorResponse("FILE_SIZE_EXCEEDED", message));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponse> handleUnexpectedException(Exception ex) {
        log.error("\uc608\uc0c1\uce58 \ubabb\ud55c \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", (Throwable)ex);
        return ResponseEntity.status((int)500).body((Object)new ErrorResponse("INTERNAL_SERVER_ERROR", "\uc608\uc0c1\uce58 \ubabb\ud55c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4."));
    }
}

